<?php

function get_page_id_by_title($law_office_lite_pagename){
  $law_office_lite_args = array(
 'post_type' => 'page',
 'posts_per_page' => 1,
 'title' => $law_office_lite_pagename
  );
  $law_office_lite_query = new WP_Query( $law_office_lite_args );    $law_office_lite_page_id = '1';
 if (isset($law_office_lite_query->post->ID)) {
      $law_office_lite_page_id = $law_office_lite_query->post->ID;
  } return $law_office_lite_page_id;
}
//about theme info
add_action( 'admin_menu', 'law_office_lite_gettingstarted' );
function law_office_lite_gettingstarted() {
	add_theme_page( esc_html__('Law Office Lite', 'law-office-lite'), esc_html__('Law Office Lite', 'law-office-lite'), 'edit_theme_options', 'law_office_lite_about', 'law_office_lite_mostrar_guide');
}

// Add a Custom CSS file to WP Admin Area
function law_office_lite_admin_theme_style() {
	wp_enqueue_style('law-office-lite-custom-admin-style', esc_url(get_template_directory_uri()) . '/includes/getstart/getstart.css');
	wp_enqueue_script('law-office-lite-tabs', esc_url(get_template_directory_uri()) . '/includes/getstart/js/tab.js');
	wp_enqueue_style( 'font-awesome-css', get_template_directory_uri().'/assets/css/fontawesome-all.css' );

	// Admin notice code START
	wp_register_script('law-office-lite-notice', esc_url(get_template_directory_uri()) . '/includes/getstart/js/notice.js', array('jquery'), time(), true);
	wp_enqueue_script('law-office-lite-notice');
	// Admin notice code END
}
add_action('admin_enqueue_scripts', 'law_office_lite_admin_theme_style');

// Changelog
if ( ! defined( 'LAW_OFFICE_LITE_CHANGELOG_URL' ) ) {
    define( 'LAW_OFFICE_LITE_CHANGELOG_URL', get_template_directory() . '/readme.txt' );
}

function law_office_lite_changelog_screen() {
	global $wp_filesystem;
	$law_office_lite_changelog_file = apply_filters( 'law_office_lite_changelog_file', LAW_OFFICE_LITE_CHANGELOG_URL );

	if ( $law_office_lite_changelog_file && is_readable( $law_office_lite_changelog_file ) ) {
		WP_Filesystem();
		$law_office_lite_changelog = $wp_filesystem->get_contents( $law_office_lite_changelog_file );
		$law_office_lite_changelog_list = law_office_lite_parse_changelog( $law_office_lite_changelog );

		// ✅ wrapper + button add kiya gaya hai
		echo '<div id="law-office-lite-changelog-container">';
		echo wp_kses_post( $law_office_lite_changelog_list );
		echo '</div>';
		echo '<button id="law-office-lite-load-more" class="button button-primary" style="margin-top:15px;">Load More</button>';
	}
}

function law_office_lite_parse_changelog( $law_office_lite_content ) {
	$law_office_lite_content = explode ( '== ', $law_office_lite_content );
	$law_office_lite_changelog_isolated = '';

	foreach ( $law_office_lite_content as $key => $law_office_lite_value ) {
		if ( strpos( $law_office_lite_value, 'Changelog ==' ) === 0 ) {
	    	$law_office_lite_changelog_isolated = str_replace( 'Changelog ==', '', $law_office_lite_value );
	    }
	}

	$law_office_lite_changelog_array = explode( '= ', $law_office_lite_changelog_isolated );
	unset( $law_office_lite_changelog_array[0] );

	$law_office_lite_changelog = '<div class="changelog">';
	foreach ( $law_office_lite_changelog_array as $law_office_lite_value ) {
		$law_office_lite_value = preg_replace( '/\n+/', '</span><span>', $law_office_lite_value );
		$law_office_lite_value = '<div class="block-changelog"><span class="heading">= ' . $law_office_lite_value . '</span></div>';
		$law_office_lite_changelog .= str_replace( '<span></span>', '', $law_office_lite_value );
	}
	$law_office_lite_changelog .= '</div>';

	return wp_kses_post( $law_office_lite_changelog );
}

//guidline for about theme
function law_office_lite_mostrar_guide() { 
	//custom function about theme customizer
	$law_office_lite_return = add_query_arg( array()) ;
	$law_office_lite_theme = wp_get_theme( 'law-office-lite' );
	?>
<div class="container-getstarted">
		<div class="inner-side-content1">
			<div class="tab-outer-box">
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/includes/getstart/images/sticky-header-logo.png" />
			</div>
		    <div class="coupon-container-box-left">
			    <div class="iner-sidebar-pro-btn">
				    <span class="premium-btn"><a href="<?php echo esc_url( LAW_OFFICE_LITE_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Premium Theme', 'law-office-lite'); ?></a>
				    </span>
			    </div>
		    </div>
        </div>					
   <div class="top-head">
	    <div class="top-title">
		     <h2><?php esc_html_e( 'Law Office Lite', 'law-office-lite' ); ?></h2>
		     <h4><?php esc_html_e( 'Welcome to WP Elemento Theme!', 'law-office-lite' ); ?></h4>
		     <p><?php esc_html_e( 'Click on the quick start button to import the demo.', 'law-office-lite' ); ?></p>
			    <div class="iner-sidebar-pro-btn">
					<?php if(!class_exists('WPElemento_Importer_ThemeWhizzie')){
						$law_office_lite_plugin_ins = Law_Office_Lite_Plugin_Activation_WPElemento_Importer::get_instance();
						$law_office_lite_actions = $law_office_lite_plugin_ins->law_office_lite_recommended_actions;
					?>
					<div class="law-office-lite-recommended-plugins ">
						<div class="law-office-lite-action-list">
							<?php if ($law_office_lite_actions): foreach ($law_office_lite_actions as $law_office_lite_key => $law_office_lite_actionValue): ?>
									<div class="law-office-lite-action" id="<?php echo esc_attr($law_office_lite_actionValue['id']);?>">
										<div class="action-inner plugin-activation-redirect">
											<?php echo wp_kses_post($law_office_lite_actionValue['link']); ?>
										</div>
									</div>
								<?php endforeach;
							endif; ?>
						</div>
					</div>
				   <?php }else{ ?>
					<span class="quick-btn">
				    <?php if (isset($_GET['imported']) && $_GET['imported'] == 'true'): ?>
                        <a href="<?php echo esc_url( site_url() ); ?>" target="_blank"><?php esc_html_e('Visit Site', 'law-office-lite'); ?></a>
						<?php
						$law_office_lite_page_id = get_page_id_by_title('Home');
						?>
						<a href="<?php echo esc_url( admin_url('post.php?post=' . $law_office_lite_page_id . '&action=elementor') ); ?>" 
							target="_blank" class="elementor-edit-btn"><?php esc_html_e('Edit With Elementor', 'law-office-lite'); ?>
						</a>
                    <?php else: ?>
                        <a href="<?php echo esc_url( admin_url('admin.php?page=wpelementoimporter-wizard') ); ?>"><?php esc_html_e('Quick Start', 'law-office-lite'); ?></a>
                    <?php endif; ?>
					<?php } ?>
				   </span>
				    <span class="premium-btn"><a href="<?php echo esc_url( LAW_OFFICE_LITE_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Premium', 'law-office-lite'); ?></a>
				    </span>
				    <span class="demo-btn"><a href="<?php echo esc_url( LAW_OFFICE_LITE_LIVE_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'law-office-lite'); ?></a>
				    </span>
				    <span class="doc-btn"><a href="<?php echo esc_url( LAW_OFFICE_LITE_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e('Theme Bundle at $79', 'law-office-lite'); ?></a>
				    </span>
			    </div>
            </div>			
		<div class="inner-side-content">
			<div class="tab-outer-box">
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/screenshot.png" />
			</div>
			<div class="top-right">
			  <span class="version"><?php esc_html_e( 'Version', 'law-office-lite' ); ?>: <?php echo esc_html($law_office_lite_theme['Version']);?></span>
		    </div>
		</div>
    </div>
    <div class="inner-cont">
	    <div class="tab-outer-box1">
		   <div class="tab-inner-box">
			   <div class= "bundle-box">
				    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/includes/getstart/images/bundle.png"/>
				    <h1><?php esc_html_e('ELEMENTOR WORDPRESS THEME BUNDLE', 'law-office-lite'); ?></h1>
			     <div>
				    <p class="product-price"><?php esc_html_e('Price:', 'law-office-lite'); ?>
                        <span class="regular-price"><?php esc_html_e('$1,999.00', 'law-office-lite'); ?></span>
                        <span class="sale-price"><?php esc_html_e('$79.00', 'law-office-lite'); ?></span>
                    </p>
					<p><?php esc_html_e('The Elementor WordPress Theme Bundle offers a stunning collection of 76+ Premium Elementor Themes', 'law-office-lite'); ?></p>
                 </div>
				</div> 
			    <div class="offer-box"> 
				    <div class="offer1-box">
                       <span class="off-text1"><a href="<?php echo esc_url( LAW_OFFICE_LITE_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e('Buy Bundle at 20% Discount', 'law-office-lite'); ?></a></span>
				    </div> 
		        </div>
			</div>	
		</div>	
		<div class="tab-outer-box2">
			<div class="tab-outer-box-2-1">
			  <h3><?php esc_html_e( 'Customizer Setting', 'law-office-lite' ); ?></h3>
			  <div class="lite-theme-inner">
				<div>
					<h3><?php esc_html_e('Theme Customizer', 'law-office-lite'); ?></h3>
					<p><?php esc_html_e('To begin customizing your website, start by clicking "Customize".', 'law-office-lite'); ?></p>
					<div class="info-link">
					   <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e('Open customizer', 'law-office-lite'); ?></a>
					</div>
				</div>
				<div>
					<h3><?php esc_html_e('Help Docs', 'law-office-lite'); ?></h3>
					<p><?php esc_html_e('The complete procedure to configure and manage a WordPress Website from the beginning is shown in this documentation .', 'law-office-lite'); ?></p>
					<div class="info-link">
						<a href="<?php echo esc_url( LAW_OFFICE_LITE_FREE_THEME_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation', 'law-office-lite'); ?></a>
					</div>
				</div>
				<div>
					<h3><?php esc_html_e('Need Support?', 'law-office-lite'); ?></h3>
					<p><?php esc_html_e('Our dedicated team is well prepared to help you out in case of queries and doubts regarding our theme.', 'law-office-lite'); ?></p>
					<div class="info-link">
						<a href="<?php echo esc_url( LAW_OFFICE_LITE_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support Forum', 'law-office-lite'); ?></a>
					</div>
				</div>
				<div>
					<h3><?php esc_html_e('Reviews & Testimonials', 'law-office-lite'); ?></h3>
					<p> <?php esc_html_e('All the features and aspects of this WordPress Theme are phenomenal. I\'d recommend this theme to all.', 'law-office-lite'); ?></p>
					<div class="info-link">
						<a href="<?php echo esc_url( LAW_OFFICE_LITE_REVIEW ); ?>" target="_blank"><?php esc_html_e('Review', 'law-office-lite'); ?></a>
					</div>
				</div>
            </div>	
		</div>
			<div class="tab-outer-box-2-2">
			  <h3><?php esc_html_e( 'Link to customizer', 'law-office-lite' ); ?></h3>
				<div class="first-row">
					<div class="row-box">
						<div class="row-box1">
							<span class="dashicons dashicons-buddicons-buddypress-logo"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[control]=custom_logo') ); ?>" target="_blank"><?php esc_html_e('Upload your Website logo','law-office-lite'); ?></a>
						</div>
						<div class="row-box2">
							<span class="dashicons dashicons-menu"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=nav_menus') ); ?>" target="_blank"><?php esc_html_e('Edit Your Menus','law-office-lite'); ?></a>
						</div>
					</div>
							
					<div class="row-box">
						<div class="row-box1">
							<span class="dashicons dashicons-align-center"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=header_image') ); ?>" target="_blank"><?php esc_html_e('Add Header Image','law-office-lite'); ?></a>
						</div>
						<div class="row-box2">
							<span class="dashicons dashicons-screenoptions"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=widgets') ); ?>" target="_blank"><?php esc_html_e('Add Footer Widget','law-office-lite'); ?></a>
						</div>
					</div>
				</div>
            </div>	
			<div class="tab-outer-box-2-3">
				<h3><?php esc_html_e( 'Change log', 'law-office-lite' ); ?></h3>	
		     <?php law_office_lite_changelog_screen(); ?>
          </div>	
        </div>
    </div>
</div>	
<?php } ?>