<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Law Office Lite
 */
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>

<meta http-equiv="Content-Type" content="<?php echo esc_attr(get_bloginfo('html_type')); ?>; charset=<?php echo esc_attr(get_bloginfo('charset')); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.2, user-scalable=yes" />

<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<?php
	if ( function_exists( 'wp_body_open' ) )
	{
		wp_body_open();
	}else{
		do_action('wp_body_open');
	}
?>
<?php if(get_theme_mod('law_office_lite_preloader_hide', false ) == true){ ?>
	<div class="loader">
		<div class="preloader">
			<div class="diamond">
				<span></span>
				<span></span>
				<span></span>
			</div>
		</div>
	</div>
<?php } ?>

<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'law-office-lite' ); ?></a>

<header id="site-navigation" class="header">
	<div class="container">
		<div class="row header-container">
			<div class="col-lg-2 col-md-3 col-sm-4 col-12 align-self-center">
				<div class="logo text-center text-md-start mb-3 mb-md-0">
					<div class="logo-image text-md-start text-center">
						<?php the_custom_logo(); ?>
					</div>
					<div class="logo-content text-md-start text-center">
						<?php
							if ( get_theme_mod('law_office_lite_display_header_title', true) == true ) :
								echo '<a href="' . esc_url(home_url('/')) . '" title="' . esc_attr(get_bloginfo('name')) . '">';
								echo esc_attr(get_bloginfo('name'));
								echo '</a>';
							endif;
							if ( get_theme_mod('law_office_lite_display_header_text', false) == true ) :
								echo '<span>'. esc_attr(get_bloginfo('description')) . '</span>';
							endif;
						?>
					</div>
				</div>
			</div>
			<div class="col-lg-10 col-md-9 col-sm-8 col-12">
				<div class="d-flex justify-content-between topheader-inner flex-wrap row-gap-1 column-gap-2 px-3">
					<?php if ( get_theme_mod('law_office_lite_header_email') ) : ?>
						<a class="mail-text" href="mailto:<?php echo esc_url( get_theme_mod('law_office_lite_header_email' ) ); ?>"><span class="email-text"><i class="fa-solid fa-envelope-open-text me-2"></i><?php echo esc_html( get_theme_mod('law_office_lite_header_email' ) ); ?></span></a>
					<?php endif; ?>
					<?php if ( get_theme_mod('law_office_lite_header_location_text') || get_theme_mod('law_office_lite_header_location_link') ) : ?>
						<a  class="adver-text" target="_blank" href="<?php echo esc_url( get_theme_mod('law_office_lite_header_location_link' ) ); ?>"><span class="location-text"><i class="fa-solid fa-location-dot me-2"></i><?php echo esc_html( get_theme_mod('law_office_lite_header_location_text' )); ?></span></a>
					<?php endif; ?>
					<?php if ( get_theme_mod('law_office_lite_header_phone_number') ) : ?>
						<a  href="tel:<?php echo esc_url( get_theme_mod('law_office_lite_header_phone_number')); ?>"><span class="phone-text" ><i class="fas fa-phone me-2"></i><?php echo esc_html( get_theme_mod('law_office_lite_header_phone_number' ) ); ?></span></a>
					<?php endif; ?>
					<div class="media-div d-flex align-items-center">
						<?php $law_office_lite_settings = get_theme_mod( 'law_office_lite_social_links_settings' ); ?>
						<div class="social-links">
							<?php if ( is_array($law_office_lite_settings) || is_object($law_office_lite_settings) ){ ?>
								<?php foreach( $law_office_lite_settings as $law_office_lite_setting ) { ?>
									<a href="<?php echo esc_url( $law_office_lite_setting['link_url'] ); ?>" target="_blank">
										<i class="<?php echo esc_attr( $law_office_lite_setting['link_text'] ); ?> me-2"></i>
									</a>
								<?php } ?>
							<?php } ?>
						</div>
					</div>
				</div>
				<div class="row bottom-header py-1">
					<div class="col-lg-9 col-md-8 col-3 align-self-center">
						<button class="menu-toggle my-2 py-2 px-3" aria-controls="top-menu" aria-expanded="false" type="button">
							<span aria-hidden="true"><i class="fa-solid fa-bars"></i></span>
						</button>
						<nav id="main-menu" class="close-panal">
							<?php
								wp_nav_menu( array(
									'theme_location' => 'main-menu',
									'container' => 'false'
								));
							?>
							<button class="close-menu my-2 p-2" type="button">
								<span aria-hidden="true"><i class="fa fa-times"></i></span>
							</button>
						</nav>
					</div>
					<div class="col-lg-3 col-md-4 col-9 align-self-center text-end">
						<?php if ( get_theme_mod('law_office_lite_header_button_text') || get_theme_mod('law_office_lite_header_button_link') ) : ?>
							<a class="mb-0 header-button" href="<?php echo esc_url( get_theme_mod('law_office_lite_header_button_link' ) ); ?>"><i class="fa-solid fa-arrow-right me-2"></i><?php echo esc_html( get_theme_mod('law_office_lite_header_button_text' )); ?></a>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</header>