<?php
/**
 * Frontpage Editor posts section
 *
 * @package Multi_Blog_Hub
 * @since 1.0.0
 */

$multi_blog_hub_editor_title       = get_theme_mod( 'editor_post_section_title', __( 'Editor Posts', 'multi-blog-hub' ) );
$multi_blog_hub_editor_sub_title   = get_theme_mod( 'editor_section_sub_title', __( 'Browse the Latest Blogs', 'multi-blog-hub' ) );
$multi_blog_hub_editor_posts_one   = get_theme_mod( 'editor_post_one' );
$multi_blog_hub_editor_posts_two   = get_theme_mod( 'editor_post_two' );
$multi_blog_hub_editor_posts_three = get_theme_mod( 'editor_post_three' );
$multi_blog_hub_editor_posts_four  = get_theme_mod( 'editor_post_four' );
$multi_blog_hub_editor_posts_five  = get_theme_mod( 'editor_post_five' );
$multi_blog_hub_ed_editor          = get_theme_mod( 'ed_editor_section', false );

if ( ! $multi_blog_hub_ed_editor && ( $multi_blog_hub_editor_title || $multi_blog_hub_editor_posts_one || $multi_blog_hub_editor_posts_two || $multi_blog_hub_editor_posts_three || $multi_blog_hub_editor_posts_four || $multi_blog_hub_editor_posts_five ) ) { ?>
	<section id="editor_section" class="editors-picks-section">
		<div class="container">
			<div class="site-main" id="main">
				<?php if ( $multi_blog_hub_editor_title ) { ?>
					<header class="section-header">
	<h2 class="section-title"><?php echo esc_html( $multi_blog_hub_editor_title ); ?></h2>
	<h3 class="section-sub-title"><?php echo esc_html( $multi_blog_hub_editor_sub_title ); ?></h3>
</header>
					<?php
				}

				if ( $multi_blog_hub_editor_posts_one || $multi_blog_hub_editor_posts_two || $multi_blog_hub_editor_posts_three || $multi_blog_hub_editor_posts_four || $multi_blog_hub_editor_posts_five ) {
					$multi_blog_hub_editor_args = array(
						'post_status'    => 'publish',
						'post_type'      => 'post',
						'orderby'        => 'post__in',
						'posts_per_page' => -1,
						'post__in'       => array_filter( array( $multi_blog_hub_editor_posts_one, $multi_blog_hub_editor_posts_two, $multi_blog_hub_editor_posts_three, $multi_blog_hub_editor_posts_four, $multi_blog_hub_editor_posts_five ) ),
					);
					$multi_blog_hub_editor_qry  = new WP_Query( $multi_blog_hub_editor_args );
					if ( $multi_blog_hub_editor_qry->have_posts() ) {
						$multi_blog_hub_post_count = 0;
						?>
						<div class="editor-posts-grid-wrapper">
							<!-- Top Row: Two Large Horizontal Cards -->
							<div class="editor-posts-top-row">
								<?php
								while ( $multi_blog_hub_editor_qry->have_posts() && $multi_blog_hub_post_count < 2 ) {
									$multi_blog_hub_editor_qry->the_post();
									++$multi_blog_hub_post_count;
									?>
									<article id="post-<?php the_ID(); ?>" <?php post_class( 'editor-post-card editor-post-large' ); ?>>
										<div class="editor-post-image-wrapper">
											<a href="<?php the_permalink(); ?>">
												<?php if ( has_post_thumbnail() ) { ?>
													<?php the_post_thumbnail( 'large', array( 'class' => 'editor-post-image' ) ); ?>
													<?php
												} else {
													good_looking_blog_get_fallback_svg( 'good_looking_blog_editor' );
												}
												?>
											</a>
										</div>
										<div class="editor-post-content-wrapper">
											<h4 class="editor-post-title">
												<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
											</h4>
											<div class="editor-post-bottom">
												<div class="editor-post-excerpt">
													<?php the_excerpt(); ?>
												</div>
												<div class="editor-post-meta">
													<span class="editor-post-date">
														<?php good_looking_blog_posted_on(); ?>
													</span>
													<span class="editor-post-author">
														<?php esc_html_e( 'By', 'multi-blog-hub' ); ?> <?php good_looking_blog_posted_by(); ?>
													</span>
												</div>
											</div>
										</div>
									</article>
								<?php } ?>
							</div><!-- .editor-posts-top-row -->

							<!-- Bottom Row: Three Small Vertical Cards -->
							<div class="editor-posts-bottom-row">
								<?php
								while ( $multi_blog_hub_editor_qry->have_posts() ) {
									$multi_blog_hub_editor_qry->the_post();
									?>
									<article id="post-<?php the_ID(); ?>" <?php post_class( 'editor-post-card editor-post-small' ); ?>>
										<div class="editor-post-category-tag">
											<?php
											$multi_blog_hub_categories = get_the_category();
											if ( ! empty( $multi_blog_hub_categories ) ) {
												echo '<a href="' . esc_url( get_category_link( $multi_blog_hub_categories[0]->term_id ) ) . '" class="category-label">' . esc_html( $multi_blog_hub_categories[0]->name ) . '</a>';
											}
											?>
										</div>
										<div class="editor-post-content-wrapper">
											<h4 class="editor-post-title">
												<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
											</h4>
											<div class="editor-post-meta">
												<span class="editor-post-date">
													<?php good_looking_blog_posted_on(); ?>
												</span>
												<span class="editor-post-author">
													<?php esc_html_e( 'By', 'multi-blog-hub' ); ?> <?php good_looking_blog_posted_by(); ?>
												</span>
											</div>
										</div>
									</article>
								<?php } ?>
							</div><!-- .editor-posts-bottom-row -->
						</div><!-- .editor-posts-grid-wrapper -->
						<?php
						wp_reset_postdata();
					}
				}
				?>
			</div>
		</div>
	</section>
	<?php
}
