jQuery(document).ready(function ($) {
    //search modal
    $('.header-search > button').on('click', function () {
        $('.header-search-form').fadeIn();
        $('.search-field').focus();
    });
    $('.header-search .close').on('click', function () {
        $('.header-search-form').fadeOut();
    });

    $('.search-form').on('click', function (e) {
        e.stopPropagation();
    });

    $('.header-search-form').on('click', function () {
        $('.header-search-form').fadeOut();
    });

    //mobile-menu
    $('<button class="angle-down"> </button>').insertAfter( $(".main-navigation.mobile-navigation ul .menu-item-has-children > a"));
    $('.main-navigation.mobile-navigation ul li .angle-down').on('click', function () {
        $(this).next().slideToggle();
        $(this).toggleClass('active');
    });

    var adminBar = document.querySelector('#wpadminbar');
    if (adminBar !== null) {
        var adminHeight = adminBar.offsetHeight;
        var mobHeaderTop = document.querySelector('.header-bottom-slide-inner');
        // mobHeaderTop.style.top = adminHeight + 'px';
    }

    //mobileheaderwhenadminbarpresent
    function styleOne() {
        if (document.querySelector('.site-header.style-one') !== null) {
            var StyleOne = document.querySelector('.site-header.style-one');
            StyleOne.style.top = adminHeight + 'px';
        }
    }
    
    window.addEventListener('resize', function () {
        styleOne();
    });

    window.addEventListener('load', function () {
        styleOne();
    });

    //accessibility
    $('.menu li a, .menu li').on('focus', function() {
        $(this).parents('li').addClass('focus');
    }).blur(function() {
        $(this).parents('li').removeClass('focus');
    });

    // Function to get scrollbar width
    function getScrollbarWidth() {
        var outer = document.createElement("div");
        outer.style.visibility = "hidden";
        outer.style.overflow = "scroll";
        outer.style.msOverflowStyle = "scrollbar";
        document.body.appendChild(outer);
        var inner = document.createElement("div");
        outer.appendChild(inner);
        var scrollbarWidth = outer.offsetWidth - inner.offsetWidth;
        outer.parentNode.removeChild(outer);
        return scrollbarWidth;
    }

    $("#menu-opener").on('click', function () {
        var scrollbarWidth = getScrollbarWidth();
        var scrollTop = window.pageYOffset || document.documentElement.scrollTop;
        
        $("body").addClass("menu-open");
        $(".mobile-menu-wrapper .primary-menu-list").addClass("toggled");
        
        // Prevent layout shift by compensating for scrollbar width
        $("body").css({
            "padding-right": scrollbarWidth + "px",
            "position": "fixed",
            "top": -scrollTop + "px",
            "width": "100%"
        });
        
        // Store scroll position for restoration
        $("body").data("scroll-position", scrollTop);
    });
  
    $(".mobile-menu-wrapper .close-main-nav-toggle ").on('click', function () {
        var scrollPosition = $("body").data("scroll-position") || 0;
        
        $("body").removeClass("menu-open");
        $(".mobile-menu-wrapper .primary-menu-list").removeClass("toggled");
        
        // Restore body styles and scroll position
        $("body").css({
            "padding-right": "",
            "position": "",
            "top": "",
            "width": ""
        });
        
        // Restore scroll position
        window.scrollTo(0, scrollPosition);
    });

});