/* ===============================================
  OPEN CLOSE Menu
============================================= */

function law_office_lite_open_menu() {
  jQuery('button.menu-toggle').addClass('close-panal');
  setTimeout(function(){
    jQuery('nav#main-menu').show();
  }, 100);

  return false;
}
jQuery( "button.menu-toggle").on("click", law_office_lite_open_menu);

function law_office_lite_close_menu() {
  jQuery('button.close-menu').removeClass('close-panal');
  jQuery('nav#main-menu').hide();
}

jQuery( "button.close-menu").on("click", law_office_lite_close_menu);

/* ===============================================
  TRAP TAB FOCUS ON MODAL MENU
============================================= */

jQuery('button.close-menu').on('keydown', function (e) {
  if (jQuery("this:focus") && !!e.shiftKey && e.keyCode === 9) {
  } else if (jQuery("this:focus") && (e.which === 9)) {
    e.preventDefault();
    jQuery(this).blur();
    jQuery('.menu li a:first').focus()
  }
});

jQuery('.menu li a:first').on('keydown', function (event) {
  if (jQuery("this:focus") && !!event.shiftKey && event.keyCode === 9) {
    event.preventDefault();
    jQuery(this).blur();
    jQuery('button.close-menu').focus()
  }
});

jQuery('#main-menu ul:first li:first a').on('keydown', function (event) {
  if (event.shiftKey && event.keyCode == 9) {
    event.preventDefault();
    jQuery(this).blur();
    jQuery('button.close-menu').focus();
  }
})

jQuery(document).ready(function() {
  window.addEventListener('load', (event) => {
      jQuery(".loader").delay(2000).fadeOut("slow");
  });
})

/* ===============================================
  Scroll Top //
============================================= */

jQuery(window).scroll(function () {
  if (jQuery(this).scrollTop() > 100) {
      jQuery('.scroll-up').fadeIn();
  } else {
      jQuery('.scroll-up').fadeOut();
  }
});

jQuery('a[href="#tobottom"]').click(function () {
  jQuery('html, body').animate({scrollTop: 0}, 'slow');
  return false;
});



/* ===============================================
  Custom Cursor
============================================= */

const law_office_lite_customCursor = {
  init: function () {
    this.law_office_lite_customCursor();
  },
  isVariableDefined: function (el) {
    return typeof el !== "undefined" && el !== null;
  },
  select: function (selectors) {
    return document.querySelector(selectors);
  },
  selectAll: function (selectors) {
    return document.querySelectorAll(selectors);
  },
  law_office_lite_customCursor: function () {
    const law_office_lite_cursorDot = this.select(".cursor-point");
    const law_office_lite_cursorOutline = this.select(".cursor-point-outline");
    if (this.isVariableDefined(law_office_lite_cursorDot) && this.isVariableDefined(law_office_lite_cursorOutline)) {
      const cursor = {
        delay: 8,
        _x: 0,
        _y: 0,
        endX: window.innerWidth / 2,
        endY: window.innerHeight / 2,
        cursorVisible: true,
        cursorEnlarged: false,
        $dot: law_office_lite_cursorDot,
        $outline: law_office_lite_cursorOutline,

        init: function () {
          this.dotSize = this.$dot.offsetWidth;
          this.outlineSize = this.$outline.offsetWidth;
          this.setupEventListeners();
          this.animateDotOutline();
        },

        updateCursor: function (e) {
          this.cursorVisible = true;
          this.toggleCursorVisibility();
          this.endX = e.clientX;
          this.endY = e.clientY;
          this.$dot.style.top = `${this.endY}px`;
          this.$dot.style.left = `${this.endX}px`;
        },

        setupEventListeners: function () {
          window.addEventListener("load", () => {
            this.cursorEnlarged = false;
            this.toggleCursorSize();
          });

          law_office_lite_customCursor.selectAll("a, button").forEach((el) => {
            el.addEventListener("mouseover", () => {
              this.cursorEnlarged = true;
              this.toggleCursorSize();
            });
            el.addEventListener("mouseout", () => {
              this.cursorEnlarged = false;
              this.toggleCursorSize();
            });
          });

          document.addEventListener("mousedown", () => {
            this.cursorEnlarged = true;
            this.toggleCursorSize();
          });
          document.addEventListener("mouseup", () => {
            this.cursorEnlarged = false;
            this.toggleCursorSize();
          });

          document.addEventListener("mousemove", (e) => {
            this.updateCursor(e);
          });

          document.addEventListener("mouseenter", () => {
            this.cursorVisible = true;
            this.toggleCursorVisibility();
            this.$dot.style.opacity = 1;
            this.$outline.style.opacity = 1;
          });

          document.addEventListener("mouseleave", () => {
            this.cursorVisible = false;
            this.toggleCursorVisibility();
            this.$dot.style.opacity = 0;
            this.$outline.style.opacity = 0;
          });
        },

        animateDotOutline: function () {
          this._x += (this.endX - this._x) / this.delay;
          this._y += (this.endY - this._y) / this.delay;
          this.$outline.style.top = `${this._y}px`;
          this.$outline.style.left = `${this._x}px`;

          requestAnimationFrame(this.animateDotOutline.bind(this));
        },

        toggleCursorSize: function () {
          if (this.cursorEnlarged) {
            this.$dot.style.transform = "translate(-50%, -50%) scale(0.75)";
            this.$outline.style.transform = "translate(-50%, -50%) scale(1.6)";
          } else {
            this.$dot.style.transform = "translate(-50%, -50%) scale(1)";
            this.$outline.style.transform = "translate(-50%, -50%) scale(1)";
          }
        },

        toggleCursorVisibility: function () {
          if (this.cursorVisible) {
            this.$dot.style.opacity = 1;
            this.$outline.style.opacity = 1;
          } else {
            this.$dot.style.opacity = 0;
            this.$outline.style.opacity = 0;
          }
        },
      };
      cursor.init();
    }
  },
};
law_office_lite_customCursor.init();

/* ===============================================
  Progress Bar
============================================= */
const law_office_lite_progressBar = {
  init: function () {
      let law_office_lite_progressBarDiv = document.getElementById("elemento-progress-bar");

      if (law_office_lite_progressBarDiv) {
          let law_office_lite_body = document.body;
          let law_office_lite_rootElement = document.documentElement;

          window.addEventListener("scroll", function (event) {
              let law_office_lite_winScroll = law_office_lite_body.scrollTop || law_office_lite_rootElement.scrollTop;
              let law_office_lite_height =
              law_office_lite_rootElement.scrollHeight - law_office_lite_rootElement.clientHeight;
              let law_office_lite_scrolled = (law_office_lite_winScroll / law_office_lite_height) * 100;
              law_office_lite_progressBarDiv.style.width = law_office_lite_scrolled + "%";
          });
      }
  },
};
law_office_lite_progressBar.init();

/* ===============================================
   sticky copyright
============================================= */

window.addEventListener('scroll', function() {
  var law_office_lite_footer = document.querySelector('.sticky-copyright');
  if (!law_office_lite_footer) return; 

  var law_office_lite_scrollTop = window.scrollY || document.documentElement.law_office_lite_scrollTop;

  if (law_office_lite_scrollTop >= 100) {
    law_office_lite_footer.classList.add('active-sticky');
  }
});

/* ===============================================
   sticky sidebar
============================================= */

window.addEventListener('scroll', function () {
  var law_office_lite_sidebar = document.querySelector('.sidebar-sticky');
  if (!law_office_lite_sidebar) return;

  var law_office_lite_scrollTop = window.scrollY || document.documentElement.scrollTop;
  var law_office_lite_windowHeight = window.innerHeight;
  var law_office_lite_documentHeight = document.documentElement.scrollHeight;

  var law_office_lite_isBottom = law_office_lite_scrollTop + law_office_lite_windowHeight >= law_office_lite_documentHeight - 100;

  if (law_office_lite_scrollTop >= 100 && !law_office_lite_isBottom) {
    law_office_lite_sidebar.classList.add('sidebar-fixed');
  } else {
    law_office_lite_sidebar.classList.remove('sidebar-fixed');
  }
});

