<?php
/**
 * Blog Section
 *
 * @package Multi_Blog_Hub
 * @since 1.0.0
 */

$multi_blog_hub_blog_section_title     = get_theme_mod( 'blog_section_title', __( 'Blog Posts', 'multi-blog-hub' ) );
$multi_blog_hub_blog_section_sub_title = get_theme_mod( 'blog_section_sub_title', __( 'Blog Posts', 'multi-blog-hub' ) );
$multi_blog_hub_ed_blog_section        = get_theme_mod( 'ed_blog_section', false );

if ( ! $multi_blog_hub_ed_blog_section && ! ( 'page' === get_option( 'show_on_front' ) ) && ( have_posts() || is_active_sidebar( 'blog' ) ) ) { ?>
	<section id="blog_section" class="blog-posts-section<?php echo is_active_sidebar( 'sidebar' ) ? esc_attr( ' blog-sidebar-activate' ) : esc_attr( ' blog-sidebar-deactivate' ); ?>">
		<div class="container">                  
		<div id="primary" class="content-area">
				<?php if ( $multi_blog_hub_blog_section_title ) { ?>
					<header class="section-header">
						<h3 class="section-title">
							<?php echo esc_html( $multi_blog_hub_blog_section_title ); ?>
						</h3>
						<h2 class="section-sub-title">
							<?php echo esc_html( $multi_blog_hub_blog_section_sub_title ); ?>
						</h2>
					</header>
				<?php } ?>
					<div class="blog-post-wrapper">
						<?php

						while ( have_posts() ) {
							the_post();
							get_template_part( 'template-parts/content', get_post_type() );
						} wp_reset_postdata();
						?>
					</div>
				<?php good_looking_blog_nav(); ?>
			</div>
		</div>
	</section>
	<?php
}
