<?php
/**
 * Frontpage Banner
 *
 * @package Multi_Blog_Hub
 * @since 1.0.0
 */

$multi_blog_hub_banner       = get_theme_mod( 'ed_banner_section', 'static_banner' );
$multi_blog_hub_banner_title = get_theme_mod( 'banner_title', __( 'Revolutionize Your Travel With These Easy-Peasy Tips', 'multi-blog-hub' ) );
$multi_blog_hub_banner_desc  = get_theme_mod( 'banner_content', __( 'Travel dates back to antiquity where wealthy Greeks and Romans would travel for leisure to their summer homes and villas in cities such as Pompeii and Baiae.', 'multi-blog-hub' ) );
$multi_blog_hub_btn_two      = get_theme_mod( 'banner_btn_two_label', __( 'Discover More', 'multi-blog-hub' ) );
$multi_blog_hub_btn_two_url  = get_theme_mod( 'banner_btn_two_link', '#' );

if ( ( 'static_banner' === $multi_blog_hub_banner ) && has_custom_header() ) { ?>
	<section id="banner_section" class="site-banner
	<?php
	if ( has_header_video() ) {
		echo esc_attr( ' video-banner' );}
	?>
	">
		<div class="container">
			<div class="tb-banner-wrapper">
				<div class="tb-row-wrap">
					<div class="tb-col-wrap">
						<div class="tb-banner-image-wrapper">
							<?php the_custom_header_markup(); ?>
						</div>      
					</div>   
					<div class="tb-col-wrap">
						<?php if ( $multi_blog_hub_banner_title || $multi_blog_hub_banner_desc || $multi_blog_hub_btn_two ) { ?> 
						<div class="">
							<div class="tb-banner-details-wrapper">
								<div class="overlay-details">
									<?php if ( $multi_blog_hub_banner_title ) { ?>
										<h2 class="item-title">
											<?php echo wp_kses_post( $multi_blog_hub_banner_title ); ?>
										</h2>
									<?php } if ( $multi_blog_hub_banner_desc ) { ?>
										<div class="banner-desc">
											<?php echo wp_kses_post( wpautop( $multi_blog_hub_banner_desc ) ); ?>
										</div>
									<?php } if ( $multi_blog_hub_btn_two ) { ?>
										<?php if ( $multi_blog_hub_btn_two && $multi_blog_hub_btn_two_url ) { ?>
											<a href="<?php echo esc_url( $multi_blog_hub_btn_two_url ); ?>" class="btn-primary"><?php echo esc_html( $multi_blog_hub_btn_two ); ?></a>
										<?php } ?>
									<?php } ?>
								</div>
							</div>
						</div>
						<?php } ?>
					</div>    
				</div>
			</div>
		</div>
	</section>
	<!-- section banner ends  -->
	<?php
}
